/* 
 * sigsuspend.c
 * 
 * Створює дочірній процес, після чого і батько, і нащадок виводять
 * повідомлення. За допомогою сигналу SIGUSR1 забезпечується першість
 * батька.
 * Ілюструє порядок організації міжзадачної взаємодії за допомогою сигналу
 * SIGUSR1, а також порядок організації пасивного чекання сигналів за
 * допомогою функції sigsuspend(). Застосовує функції sigprocmask(),
 * sigaction(), kill(), sigsuspend().
 *
 */

#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


/* Обробник сигналу SIGUSR1 */
void sig_handler(int signum)
{
}

int main()
{
        sigset_t set;
        pid_t pid;

        /* Ініціалізує порожній набір сигналів. */
        if (sigemptyset(&set) == -1) {
                perror("sigemptyset()");
                exit(EXIT_FAILURE);
        }
        /* Додає в набір сигнал SIGUSR1. */
        if (sigaddset(&set, SIGUSR1) != 0) {
                perror("sigaddset()");
                exit(EXIT_FAILURE);
        }
        /* Блокує сигнал SIGUSR1. */
        if (sigprocmask(SIG_SETMASK, &set, NULL) != 0) {
                perror("sigprocmask()");
                exit(EXIT_FAILURE);
        }
        /* Створює дочірній процес */
        pid = fork();
        if (pid < 0) {
                perror("fork()");
                exit(EXIT_FAILURE);
        }
        if (pid == 0) {
                /* Це код дочірнього процесу */
                struct sigaction act;
                sigset_t suspendset;

                /* Реєструє обробник для SIGUSR1. */
                memset(&act, 0, sizeof(act));
                act.sa_handler = sig_handler;
                if (sigaction(SIGUSR1, &act, NULL) != 0) {
                        perror("sigaction()");
                        exit(EXIT_FAILURE);
                }
                /* Ініціалізує набір сигналів, який включає всі можливі
                   сигнали. */
                if (sigfillset(&suspendset) != 0) {
                        perror("sigfillset()");
                        exit(EXIT_FAILURE);
                }
                /* Вилучає з набору сигнал SIGUSR1. */
                if (sigdelset(&suspendset, SIGUSR1) != 0) {
                        perror("sigdelset()");
                        exit(EXIT_FAILURE);
                }
                /* Блокує всі сигнали, окрім SIGUSR1, і чекає, доки йому
                   буде доставлено сигнал (SIGUSR1). */
                if (sigsuspend(&suspendset) != 0 && errno != EINTR) {
                        perror("sigsuspend()");
                        exit(EXIT_FAILURE);
                }
                /* Виводить повідомлення. */
                printf("Нащадок\n");
                /* Завершує роботу. */
                exit(EXIT_SUCCESS);
        }
        /* Це код батька */
        /* Виводить повідомлення. */
        printf("Батько\n");
        /* Передає нащадку сигнал SIGUSR1. */
        if (kill(pid, SIGUSR1) != 0) {
                perror("kill()");
                exit(EXIT_FAILURE);
        }
        /* Призупиняється (інакше нащадок втратить зв'язок із терміналом
           і не зможе вивести повідомлення). */
        pause();
        /* Завершує роботу. */
        exit(EXIT_SUCCESS);
}
